/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client.dsl;

import com.google.common.collect.ImmutableList;
import com.zentadata.client.dsl.Expression;
import com.zentadata.client.error.ConfigException;
import java.util.List;

public class Function {
    static Expression fun(String fun, Expression ... expressions) {
        return new Expression.Fun(fun, expressions);
    }

    static Expression obj(Object value) {
        if (value instanceof String || value instanceof Number) {
            return new Expression.Obj(value);
        }
        throw new ConfigException(String.format("unsupported argument type [%s]", value.getClass()));
    }

    public static Expression col(String value) {
        return new Expression.Col(value, null);
    }

    public static Expression lit(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return new Expression.Lit(value);
    }

    public static Expression asc(String columnName) {
        return Function.fun("asc", Function.lit(columnName));
    }

    public static Expression desc(String columnName) {
        return Function.fun("desc", Function.lit(columnName));
    }

    public static Expression expr(String expr) {
        return Function.fun("expr", Function.lit(expr));
    }

    public static Expression not(Expression expr) {
        return Function.fun("not", expr);
    }

    public static Expression when(Expression condition, Expression value) {
        return Function.fun("when", condition, value);
    }

    public static Expression coalesce(Expression ... expressions) {
        return Function.fun("coalesce", expressions);
    }

    public static Expression struct(Expression ... expressions) {
        return Function.fun("struct", expressions);
    }

    public static Expression count(Object value) {
        return Function.fun("count", Function.lit(value));
    }

    public static Expression count_distinct(Expression expression) {
        return Function.fun("count_distinct", expression);
    }

    public static Expression first(Expression expression) {
        return Function.fun("first", expression);
    }

    public static Expression last(Expression expression) {
        return Function.fun("last", expression);
    }

    public static Expression sum(Expression expression) {
        return Function.fun("sum", expression);
    }

    public static Expression max(Expression expression) {
        return Function.fun("max", expression);
    }

    public static Expression avg(Expression expression) {
        return Function.fun("avg", expression);
    }

    public static Expression min(Expression expression) {
        return Function.fun("min", expression);
    }

    public static Expression collect_list(Expression expression) {
        return Function.fun("collect_list", expression);
    }

    public static Expression collect_set(Expression expression) {
        return Function.fun("collect_set", expression);
    }

    public static Expression sha1(Expression expression) {
        return Function.fun("sha1", expression);
    }

    public static Expression length(Expression expression) {
        return Function.fun("length", expression);
    }

    public static Expression split(Expression col, String pattern) {
        return Function.fun("split", col, Function.lit(pattern));
    }

    public static String $(String ... sql) {
        return String.join((CharSequence)System.lineSeparator(), sql);
    }

    public static Expression array_sum(Expression expression) {
        return Function.fun("array_sum", expression);
    }

    public static Expression concat(Expression ... expressions) {
        return Function.fun("concat", expressions);
    }

    public static Expression map(Expression ... expressions) {
        return Function.fun("map", expressions);
    }

    public static Expression array(Expression ... expressions) {
        return Function.fun("array", expressions);
    }

    public static Expression explode(Expression expression) {
        return Function.fun("explode", expression);
    }

    public static <T> List<T> list(T ... obj) {
        return ImmutableList.builder().add((Object[])obj).build();
    }

    public static Expression to_sec(Expression col) {
        return Function.fun("to_sec", col);
    }

    public static Expression to_date(Expression col) {
        return Function.fun("to_date", col);
    }

    public static Expression date_now() {
        return Function.fun("date_now", new Expression[0]);
    }

    public static Expression parse_date(Expression col, String format) {
        return Function.fun("parse_date", col, Function.lit(format));
    }

    public static Expression format_date(Expression col, String format) {
        return Function.fun("format_date", col, Function.lit(format));
    }

    public static Expression date_diff(Expression col1, Expression col2) {
        return Function.fun("date_diff", col1, col2);
    }

    public static Expression to_utc_date(Expression col, String timezone) {
        return Function.fun("to_utc_date", col, Function.lit(timezone));
    }

    public static Expression from_utc_date(Expression col, String timezone) {
        return Function.fun("from_utc_date", col, Function.lit(timezone));
    }
}

