/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.zentadata.client.DataFrame;
import com.zentadata.client.DataFrameBuilder;
import com.zentadata.client.RestClient;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.engine.Session;
import com.zentadata.client.synsugar.Catalog;
import com.zentadata.client.synsugar.Sql;

public class ZenSession
implements Session {
    private final DataEngine engine;
    private final Catalog catalog;

    public ZenSession(String host, int port) {
        this.engine = new RestClient(host, port);
        this.catalog = new Catalog(this);
    }

    public ZenSession(String host, int port, String username, String password) {
        this.engine = new RestClient(host, port, username, password);
        this.catalog = new Catalog(this);
    }

    @Override
    public DataFrameBuilder read(String dataLinkId) {
        return DataFrameBuilder.newBuilder(this.engine).dataLinkId(dataLinkId);
    }

    @Override
    public Catalog catalog() {
        return this.catalog;
    }

    @Override
    public DataFrame sql(String query) {
        return Sql.query(this, query);
    }
}

