/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.google.common.collect.ImmutableMap;
import com.zentadata.client.DataFrame;
import com.zentadata.client.WriteRequest;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.error.JobException;
import com.zentadata.client.option.DataFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WriteRequestBuilder {
    private String dataLinkId;
    private DataFormat dataFormat;
    private DataFrame zdf;
    private String[] partitions;
    private final Map<String, String> options = new HashMap<String, String>();
    private final DataEngine engine;

    private WriteRequestBuilder(DataEngine engine) {
        this.engine = engine;
    }

    static WriteRequestBuilder newBuilder(DataEngine engine) {
        return new WriteRequestBuilder(engine);
    }

    WriteRequestBuilder dataLinkId(String dataLinkId) {
        this.dataLinkId = dataLinkId;
        return this;
    }

    WriteRequestBuilder datafram(DataFrame zdf) {
        this.zdf = zdf;
        return this;
    }

    public WriteRequestBuilder format(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public WriteRequestBuilder option(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public WriteRequestBuilder partitionBy(String ... partitions) {
        this.partitions = partitions;
        return this;
    }

    public void to(String destination) throws JobException {
        WriteRequest req = new WriteRequest(this.dataLinkId, destination, this.dataFormat, (Map<String, String>)ImmutableMap.copyOf(this.options), this.zdf, this.partitions);
        try {
            this.engine.write(req);
        }
        catch (IOException e) {
            String error = String.format("write request failed [cause=%s]", e.getMessage());
            throw new JobException(error, e);
        }
    }
}

