/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zentadata.client.ResultSet;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import de.vandermeer.asciithemes.a7.A7_Grids;
import java.util.function.Consumer;

class ResultSetPrinter {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_JSON = "application/json";
    private final Consumer<String> consumer;
    private final ObjectMapper mapper;
    private final String contentType;

    ResultSetPrinter(Consumer<String> consumer) {
        this(consumer, null, TEXT_PLAIN);
    }

    ResultSetPrinter(Consumer<String> consumer, ObjectMapper mapper, String contentType) {
        this.consumer = consumer;
        this.mapper = mapper;
        this.contentType = contentType;
    }

    void print(ResultSet resultSet) {
        if (TEXT_PLAIN.equals(this.contentType)) {
            this.printPlain(resultSet);
        } else if (APPLICATION_JSON.equals(this.contentType)) {
            this.printJson(resultSet);
        }
    }

    private void printPlain(ResultSet resultSet) {
        AsciiTable at = new AsciiTable();
        at.getContext().setGrid(A7_Grids.minusBarPlusEquals());
        at.getRenderer().setCWC((AT_ColumnWidthCalculator)new CWC_LongestLine());
        this.addStatus(resultSet, at);
        this.addHeader(resultSet, at);
        this.addRows(resultSet, at);
        this.consumer.accept(at.render());
    }

    private void printJson(ResultSet resultSet) {
        try {
            String body = this.mapper.writeValueAsString(resultSet.getPayload());
            this.consumer.accept(body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    void describe(ResultSet resultSet) {
        this.consumer.accept(resultSet.schema);
    }

    private void addStatus(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().isEmpty()) {
            at.addStrongRule();
            at.addRow(new Object[]{"no records found"});
            at.addStrongRule();
        }
    }

    private void addHeader(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().size() > 0) {
            at.addRule();
            at.addRow(resultSet.getPayload().get(0).keySet().toArray());
        }
    }

    private void addRows(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().size() > 0) {
            at.addRule();
            resultSet.getPayload().forEach(row -> {
                Object[] cells = row.values().stream().map(val -> {
                    if (null == val) {
                        return "null";
                    }
                    return val;
                }).toArray();
                at.addRow(cells);
            });
            at.addRule();
        }
    }
}

