/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zentadata.client.ResultSetIterator;
import com.zentadata.client.ResultSetPrinter;
import com.zentadata.client.error.ConfigException;
import com.zentadata.client.model.Cursor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
public class ResultSet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<Map<String, Object>> payload;
    protected final String schema;
    protected final Cursor cursor;
    @JsonIgnore
    private ResultSetPrinter resultSetPrinter;
    @JsonIgnore
    private ResultSetIterator iterator;

    public ResultSet(@JsonProperty(value="payload") List<Map<String, Object>> payload, @JsonProperty(value="cursor") Cursor cursor, @JsonProperty(value="schema") String schema) {
        this.payload = payload;
        this.cursor = cursor;
        this.schema = schema;
    }

    void setResultSetPrinter(ResultSetPrinter resultSetPrinter) {
        this.resultSetPrinter = resultSetPrinter;
    }

    void setIterator(ResultSetIterator iterator) {
        this.iterator = iterator;
    }

    protected Cursor getCursor() {
        return this.cursor;
    }

    public void show() {
        if (this.resultSetPrinter == null) {
            throw new ConfigException("resultSetPrinter is not defined");
        }
        this.resultSetPrinter.print(this);
    }

    public List<Map<String, Object>> getPayload() {
        return this.payload;
    }

    public <T> List<T> getPayload(Class<T> clas) {
        return this.payload.stream().map(obj -> MAPPER.convertValue(obj, clas)).collect(Collectors.toList());
    }

    public Iterator<Map<String, Object>> getIterator() {
        return this.iterator;
    }

    public <T> Iterator<T> getIterator(Class<T> clas) {
        ResultSetIterator resultSetIterator = this.iterator;
        resultSetIterator.getClass();
        return resultSetIterator.new ResultSetIterator.ResultSetIteratorTyped<T>(clas);
    }

    public void describe() {
        if (this.resultSetPrinter == null) {
            throw new ConfigException("resultSetPrinter is not defined");
        }
        this.resultSetPrinter.describe(this);
    }
}

