/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client.dsl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.zentadata.client.dsl.ExpressionBuilder;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Col.class, name="Col"), @JsonSubTypes.Type(value=Lit.class, name="Lit"), @JsonSubTypes.Type(value=Obj.class, name="Obj"), @JsonSubTypes.Type(value=Fun.class, name="Fun")})
public abstract class Expression
extends ExpressionBuilder {
    @Override
    protected Expression self() {
        return this;
    }

    public static class Fun
    extends Expression {
        public final String fun;
        public final List<Expression> arg;

        Fun(@JsonProperty(value="value") String fun, Expression ... arg) {
            this.fun = fun;
            this.arg = ImmutableList.copyOf((Object[])arg);
        }

        public String toString() {
            return "Fun{fun=" + this.fun + ", arg=" + this.arg + '}';
        }
    }

    public static class Obj
    extends Expression {
        public final Object value;

        Obj(@JsonProperty(value="value") Object value) {
            this.value = value;
        }

        public String toString() {
            return "Obj{" + this.value + "}";
        }
    }

    public static class Lit
    extends Expression {
        public final Object value;

        Lit(@JsonProperty(value="value") Object value) {
            this.value = value;
        }

        public String toString() {
            return "Lit{" + this.value + "}";
        }
    }

    public static class Col
    extends Expression {
        public final String value;
        public final String stage;

        public Col(@JsonProperty(value="value") String value, @JsonProperty(value="stage") String stage) {
            this.value = value;
            this.stage = stage;
        }

        public String toString() {
            return "Col{" + this.value + "}";
        }
    }
}

