/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.zentadata.client.ResultSet;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import de.vandermeer.asciithemes.a7.A7_Grids;
import java.util.function.Consumer;

class ResultSetPrinter {
    private final Consumer<String> consumer;

    ResultSetPrinter(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    void print(ResultSet resultSet) {
        AsciiTable at = new AsciiTable();
        at.getContext().setGrid(A7_Grids.minusBarPlusEquals());
        at.getRenderer().setCWC((AT_ColumnWidthCalculator)new CWC_LongestLine());
        this.addStatus(resultSet, at);
        this.addHeader(resultSet, at);
        this.addRows(resultSet, at);
        this.consumer.accept(at.render());
    }

    private void addStatus(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().isEmpty()) {
            at.addStrongRule();
            at.addRow(new Object[]{"no records found"});
            at.addStrongRule();
        }
    }

    private void addHeader(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().size() > 0) {
            at.addRule();
            at.addRow(resultSet.getPayload().get(0).keySet().toArray());
        }
    }

    private void addRows(ResultSet resultSet, AsciiTable at) {
        if (resultSet.getPayload().size() > 0) {
            at.addRule();
            resultSet.getPayload().forEach(row -> {
                Object[] cells = row.values().stream().map(val -> {
                    if (null == val) {
                        return "null";
                    }
                    return val;
                }).toArray();
                at.addRow(cells);
            });
            at.addRule();
        }
    }
}

