/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zentadata.client.ResultSet;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.model.Cursor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class ResultSetIterator
implements Iterator<Map<String, Object>> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Cursor cursor;
    private final DataEngine engine;
    private Iterator<Map<String, Object>> iterator;

    public ResultSetIterator(ResultSet resultSet, DataEngine engine) {
        this.cursor = resultSet.getCursor();
        this.engine = engine;
        this.iterator = resultSet.getPayload().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        try {
            Optional<ResultSet> resOpt = this.engine.next(this.cursor);
            if (resOpt.isPresent()) {
                this.iterator = resOpt.get().getPayload().iterator();
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public Map<String, Object> next() {
        return this.iterator.next();
    }

    class ResultSetIteratorTyped<T>
    implements Iterator<T> {
        private final Class<T> clas;

        public ResultSetIteratorTyped(Class<T> clas) {
            this.clas = clas;
        }

        @Override
        public boolean hasNext() {
            return ResultSetIterator.this.hasNext();
        }

        @Override
        public T next() {
            return (T)MAPPER.convertValue(ResultSetIterator.this.next(), this.clas);
        }
    }
}

