/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zentadata.client.DataFrame;
import com.zentadata.client.ResultSet;
import com.zentadata.client.ResultSetIterator;
import com.zentadata.client.ResultSetPrinter;
import com.zentadata.client.WriteRequest;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.error.ConfigException;
import com.zentadata.client.error.JobException;
import com.zentadata.client.model.Cursor;
import com.zentadata.client.model.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;

class RestClient
implements DataEngine {
    private final String host;
    private final int port;
    private final String jsession;
    private final ObjectMapper mapper = new ObjectMapper();

    RestClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.jsession = "anonymous";
    }

    RestClient(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        try {
            this.jsession = this.authenticate(host, port, username, password);
        }
        catch (IOException e) {
            throw new ConfigException("authentication failed", e);
        }
    }

    @Override
    public ResultSet collect(DataFrame de) throws IOException, JobException {
        String body = this.mapper.writeValueAsString((Object)de);
        HttpResponse rsp = Request.Post((String)String.format("http://%s:%d/job/collect", this.host, this.port)).bodyString(body, ContentType.APPLICATION_JSON).addHeader("Cookie", "JSESSIONID=" + this.jsession).execute().returnResponse();
        this.handleErrorResponse(rsp, JobException::new);
        String json = IOUtils.toString((InputStream)rsp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        ResultSet res = (ResultSet)this.mapper.readValue(json, ResultSet.class);
        res.setResultSetPrinter(new ResultSetPrinter(System.out::println));
        res.setIterator(new ResultSetIterator(res, this));
        return res;
    }

    @Override
    public void write(WriteRequest request) throws IOException, JobException {
        String body = this.mapper.writeValueAsString((Object)request);
        HttpResponse rsp = Request.Post((String)String.format("http://%s:%d/job/write", this.host, this.port)).bodyString(body, ContentType.APPLICATION_JSON).addHeader("Cookie", "JSESSIONID=" + this.jsession).execute().returnResponse();
        this.handleErrorResponse(rsp, JobException::new);
    }

    @Override
    public Optional<ResultSet> next(Cursor cursor) throws IOException {
        HttpResponse rsp = Request.Post((String)String.format("http://%s:%d/job/cursor/%s/next", this.host, this.port, cursor.getId())).addHeader("Cookie", "JSESSIONID=" + this.jsession).execute().returnResponse();
        if (rsp.getStatusLine().getStatusCode() == 404) {
            return Optional.empty();
        }
        this.handleErrorResponse(rsp, JobException::new);
        String json = IOUtils.toString((InputStream)rsp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        ResultSet res = (ResultSet)this.mapper.readValue(json, ResultSet.class);
        return Optional.of(res);
    }

    private String authenticate(String host, int port, String username, String password) throws IOException {
        HttpResponse rsp = Request.Post((String)String.format("http://%s:%d/login", host, port)).bodyForm(new NameValuePair[]{new BasicNameValuePair("username", username), new BasicNameValuePair("password", password)}).execute().returnResponse();
        this.handleErrorResponse(rsp, ConfigException::new);
        return rsp.getFirstHeader("Set-Cookie").getElements()[0].getValue();
    }

    private void handleErrorResponse(HttpResponse rsp, Function<String, RuntimeException> exceptionBuilder) throws IOException {
        if (rsp.getStatusLine().getStatusCode() == 401) {
            throw new ConfigException("unauthorized request");
        }
        if (rsp.getStatusLine().getStatusCode() != 200) {
            String json = IOUtils.toString((InputStream)rsp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Response res = (Response)this.mapper.readValue(json, Response.class);
            throw exceptionBuilder.apply(res.message);
        }
    }
}

