/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zentadata.client.error.ConfigException;
import com.zentadata.client.model.ResultSetPrinter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultSet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<Map<String, Object>> payload;
    @JsonIgnore
    private ResultSetPrinter resultSetPrinter;

    public ResultSet(@JsonProperty(value="payload") List<Map<String, Object>> payload) {
        this.payload = payload;
    }

    public void setResultSetPrinter(ResultSetPrinter resultSetPrinter) {
        this.resultSetPrinter = resultSetPrinter;
    }

    public void show() {
        if (this.resultSetPrinter == null) {
            throw new ConfigException("resultSetPrinter is not defined");
        }
        this.resultSetPrinter.print(this);
    }

    public List<Map<String, Object>> getPayload() {
        return this.payload;
    }

    public <T> List<T> getPayload(Class<T> clas) {
        return this.payload.stream().map(obj -> MAPPER.convertValue(obj, clas)).collect(Collectors.toList());
    }
}

