/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.zentadata.client.DataFrame;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.option.DataFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DataFrameBuilder {
    private String dataLinkId;
    private List<String> reference;
    private DataFormat dataFormat;
    private final Map<String, String> options = new HashMap<String, String>();
    private final DataEngine engine;

    private DataFrameBuilder(DataEngine engine) {
        this.engine = engine;
    }

    public static DataFrameBuilder newBuilder(DataEngine engine) {
        return new DataFrameBuilder(engine);
    }

    public DataFrameBuilder dataLinkId(String dataLinkId) {
        this.dataLinkId = dataLinkId;
        return this;
    }

    public DataFrameBuilder format(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public DataFrameBuilder option(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public DataFrame from(String source, String ... sources) {
        ArrayList<String> resList = new ArrayList<String>();
        List<String> sourcesList = Arrays.asList(sources);
        resList.add(source);
        resList.addAll(sourcesList);
        this.reference = resList;
        return this.build();
    }

    public DataFrame build() {
        String uid = UUID.randomUUID().toString();
        DataFrame de = new DataFrame(this.dataLinkId, this.reference, this.dataFormat, (Map<String, String>)ImmutableMap.copyOf(this.options), (List<DataFrame.Operation>)ImmutableList.of(), uid);
        de.setDataEngine(this.engine);
        return de;
    }
}

