/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client.dsl;

import com.zentadata.client.dsl.Expression;
import com.zentadata.client.dsl.Function;

abstract class ExpressionBuilder {
    ExpressionBuilder() {
    }

    protected abstract Expression self();

    public Expression as(String name) {
        return Function.fun("as", this.self(), Function.lit(name));
    }

    public Expression and(Expression col) {
        return Function.fun("and", this.self(), col);
    }

    public Expression or(Expression col) {
        return Function.fun("or", this.self(), col);
    }

    public Expression equalTo(Object value) {
        return Function.fun("equalTo", this.self(), Function.lit(value));
    }

    public Expression notEqual(Object value) {
        return Function.fun("notEqual", this.self(), Function.lit(value));
    }

    public Expression gt(Object value) {
        return Function.fun("gt", this.self(), Function.lit(value));
    }

    public Expression lt(Object value) {
        return Function.fun("lt", this.self(), Function.lit(value));
    }

    public Expression leq(Object value) {
        return Function.fun("leq", this.self(), Function.lit(value));
    }

    public Expression geq(Object value) {
        return Function.fun("geq", this.self(), Function.lit(value));
    }

    public Expression between(Object lower, Object upper) {
        return Function.fun("between", this.self(), Function.lit(lower), Function.lit(upper));
    }

    public Expression isNull() {
        return Function.fun("isNull", this.self());
    }

    public Expression isNotNull() {
        return Function.fun("isNotNull", this.self());
    }

    public Expression like(String name) {
        return Function.fun("like", this.self(), Function.lit(name));
    }

    public Expression when(Expression condition, Expression value) {
        return Function.fun("when", this.self(), condition, value);
    }

    public Expression otherwise(Expression value) {
        return Function.fun("otherwise", this.self(), value);
    }

    private Expression getItem(Object value) {
        return Function.fun("getItem", this.self(), Function.obj(value));
    }

    public Expression getItem(Number value) {
        return this.getItem((Object)value);
    }

    public Expression getItem(String value) {
        return this.getItem((Object)value);
    }

    public Expression plus(Object value) {
        return Function.fun("plus", this.self(), Function.lit(value));
    }

    public Expression minus(Object value) {
        return Function.fun("minus", this.self(), Function.lit(value));
    }

    public Expression multiply(Object value) {
        return Function.fun("multiply", this.self(), Function.lit(value));
    }

    public Expression divide(Object value) {
        return Function.fun("divide", this.self(), Function.lit(value));
    }

    public Expression mod(Object value) {
        return Function.fun("mod", this.self(), Function.lit(value));
    }

    public Expression contains(Object value) {
        return Function.fun("contains", this.self(), Function.lit(value));
    }

    public Expression startsWith(Object value) {
        return Function.fun("starts_with", this.self(), Function.lit(value));
    }

    public Expression endsWith(Object value) {
        return Function.fun("ends_with", this.self(), Function.lit(value));
    }

    public Expression toInt() {
        return Function.fun("toInt", this.self());
    }

    public Expression toLong() {
        return Function.fun("toLong", this.self());
    }

    public Expression toFloat() {
        return Function.fun("toFloat", this.self());
    }

    public Expression toDouble() {
        return Function.fun("toDouble", this.self());
    }

    public Expression toDecimal(int precision, int scale) {
        return Function.fun("toDecimal", this.self(), Function.lit(precision), Function.lit(scale));
    }

    public Expression toStr() {
        return Function.fun("toStr", this.self());
    }

    public Expression toBool() {
        return Function.fun("toBool", this.self());
    }
}

