/*
 * Decompiled with CFR 0.152.
 */
package com.zentadata.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.zentadata.client.WriteRequestBuilder;
import com.zentadata.client.dsl.Expression;
import com.zentadata.client.engine.DataEngine;
import com.zentadata.client.error.JobException;
import com.zentadata.client.model.ResultSet;
import com.zentadata.client.option.DataFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DataFrame {
    public final String dataLinkId;
    public final List<String> reference;
    public final DataFormat dataFormat;
    public final Map<String, String> options;
    public final List<Operation> ops;
    public final String stage;
    private DataEngine engine;

    DataFrame(@JsonProperty(value="dataLinkId") String dataLinkId, @JsonProperty(value="reference") List<String> reference, @JsonProperty(value="dataFormat") DataFormat dataFormat, @JsonProperty(value="options") Map<String, String> options, @JsonProperty(value="operations") List<Operation> ops, @JsonProperty(value="stage") String stage) {
        this.dataLinkId = dataLinkId;
        this.reference = reference;
        this.dataFormat = dataFormat;
        this.options = options;
        this.ops = ops;
        this.stage = stage;
    }

    private List<Operation> merge(Operation op) {
        return new ImmutableList.Builder().addAll(this.ops).add((Object)op).build();
    }

    private DataFrame addOperation(Operation op) {
        DataFrame newDe = new DataFrame(this.dataLinkId, this.reference, this.dataFormat, this.options, this.merge(op), this.stage);
        newDe.setDataEngine(this.engine);
        return newDe;
    }

    private String uuid() {
        return UUID.randomUUID().toString();
    }

    public DataFrame select(Expression ... expressions) {
        return this.addOperation(new Select((List)ImmutableList.copyOf((Object[])expressions), this.uuid()));
    }

    public DataFrame where(Expression expr) {
        return this.addOperation(new Where(expr, this.uuid()));
    }

    public DataFrame join(DataFrame de, Expression expr) {
        return this.addOperation(new Join(de, expr, this.uuid()));
    }

    public DataFrame leftJoin(DataFrame de, Expression expr) {
        return this.addOperation(new LeftJoin(de, expr, this.uuid()));
    }

    public DataFrame groupBy(List<Expression> group, Expression ... aggs) {
        return this.addOperation(new GroupBy(group, (List)ImmutableList.copyOf((Object[])aggs), this.uuid()));
    }

    public DataFrame limit(int limit) {
        return this.addOperation(new Limit(limit, this.uuid()));
    }

    public DataFrame sort(Expression ... expressions) {
        return this.addOperation(new Sort((List)ImmutableList.copyOf((Object[])expressions), this.uuid()));
    }

    public Expression col(String value) {
        String stage = this.ops.size() > 0 ? this.ops.get(this.ops.size() - 1).getStage() : this.stage;
        return new Expression.Col(value, stage);
    }

    public String toString() {
        return "DataFrame{dataLinkId='" + this.dataLinkId + '\'' + ", reference='" + this.reference + '\'' + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", options=" + this.options + ", ops=" + this.ops + '}';
    }

    void setDataEngine(DataEngine engine) {
        this.engine = engine;
    }

    public ResultSet collect() throws JobException {
        try {
            return this.engine.collect(this);
        }
        catch (IOException e) {
            throw new JobException(String.format("dataframe collect operation failed [%s]", e), e);
        }
    }

    public WriteRequestBuilder write(String dataLinkId) {
        return WriteRequestBuilder.newBuilder(this.engine).dataLinkId(dataLinkId).datafram(this);
    }

    public static class Sort
    implements Operation {
        public final List<Expression> expressions;
        private final String stage;

        private Sort(@JsonProperty(value="expressions") List<Expression> expressions, @JsonProperty(value="stage") String stage) {
            this.expressions = expressions;
            this.stage = stage;
        }

        public String toString() {
            return "Sort{expressions=" + this.expressions + '}';
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    public static class Limit
    implements Operation {
        public final int limit;
        private final String stage;

        private Limit(@JsonProperty(value="limit") int limit, @JsonProperty(value="stage") String stage) {
            this.limit = limit;
            this.stage = stage;
        }

        public String toString() {
            return "Limit{limit=" + this.limit + '}';
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    public static class GroupBy
    implements Operation {
        public final List<Expression> groupBy;
        public final List<Expression> aggs;
        private final String stage;

        private GroupBy(@JsonProperty(value="groupBy") List<Expression> groupBy, @JsonProperty(value="aggs") List<Expression> aggs, @JsonProperty(value="stage") String stage) {
            this.groupBy = groupBy;
            this.aggs = aggs;
            this.stage = stage;
        }

        public String toString() {
            return "\nGroupBy{groupBy=" + this.groupBy + ", agg=" + this.aggs + '}';
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    public static class LeftJoin
    extends Join {
        private LeftJoin(@JsonProperty(value="dataFrame") DataFrame dataFrame, @JsonProperty(value="expression") Expression expression, @JsonProperty(value="stage") String stage) {
            super(dataFrame, expression, stage);
        }

        @Override
        public String toString() {
            return "\nLeftJoin{dataFrame=" + this.dataFrame + ", expression=" + this.expression + '}';
        }
    }

    public static class Join
    implements Operation {
        public final DataFrame dataFrame;
        public final Expression expression;
        private final String stage;

        private Join(@JsonProperty(value="dataFrame") DataFrame dataFrame, @JsonProperty(value="expression") Expression expression, @JsonProperty(value="stage") String stage) {
            this.dataFrame = dataFrame;
            this.expression = expression;
            this.stage = stage;
        }

        public String toString() {
            return "\nJoin{dataFrame=" + this.dataFrame + ", expression=" + this.expression + '}';
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    public static class Where
    implements Operation {
        public final Expression expression;
        private final String stage;

        private Where(@JsonProperty(value="expression") Expression expression, @JsonProperty(value="stage") String stage) {
            this.expression = expression;
            this.stage = stage;
        }

        public String toString() {
            return "\nWhere{expression=" + this.expression + "}";
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    public static class Select
    implements Operation {
        public final List<Expression> expressions;
        private final String stage;

        private Select(@JsonProperty(value="expressions") List<Expression> expressions, @JsonProperty(value="stage") String stage) {
            this.expressions = expressions;
            this.stage = stage;
        }

        public String toString() {
            return "\nSelect{expressions=" + this.expressions + "}";
        }

        @Override
        public String getStage() {
            return this.stage;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Select.class, name="Select"), @JsonSubTypes.Type(value=Where.class, name="Where"), @JsonSubTypes.Type(value=Join.class, name="Join"), @JsonSubTypes.Type(value=LeftJoin.class, name="LeftJoin"), @JsonSubTypes.Type(value=GroupBy.class, name="GroupBy"), @JsonSubTypes.Type(value=Limit.class, name="Limit"), @JsonSubTypes.Type(value=Sort.class, name="Sort")})
    public static interface Operation {
        public String getStage();
    }
}

